﻿/*  NEEDS THESE THINGS:
	_this
	image
	walkInertia.as  (as walk_obj)
	react.as
	loadImage.as
	callUnload.as
	[walkSpeed]
	"terrainChange" event
	"swf\splash.swf" file
	"swf\waterFeet.swf" file
	
INTERFACE:
	swim_obj.enable()
	swim_obj.disable()
	swim_obj.waterTerrain []
*/
swim_obj = runFunc(function(){
	var swim_waterDepth = 8;
	var waterTerrain = [2];
	var wallTerrain = walk_obj.wallValues || [1];
	
	var waterFeet_depth = 20;
	var waterFeet_name = "waterFeet";
	#include "../walkSpeed.as"
	walkSpeed.swim = {
		walkSpeed: 1.5,
		acel: 0.15,
		decel: 0.99
	}
	
	var swim_obj = {
		waterTerrain: waterTerrain,
		terrainChange: function(evt){
			var newTerrain = evt.newTerrain;
			var oldTerrain = evt.oldTerrain;
			if( isWaterTerrain(newTerrain)  &&  !isWaterTerrain(oldTerrain) )
			{// if:  just stepped onto water
				// splash anim  &  sound
				if(oldTerrain != undefined){
					showSplash();
				}// if:  not starting on water
				
				walkSpeed.change( "swim" );
				walk_obj.xVel = 0;
				walk_obj.yVel = 0;
				
				
				if(_visible)		addSwimEffect();
			}// if:  just stepped onto water
			else if( !isWaterTerrain(newTerrain)  &&  isWaterTerrain(oldTerrain) )
			{// if:  just stepped OUT of water
				// splash anim  &  sound
				if(oldTerrain != undefined){
					showSplash();
				}// if:  not starting on water
				
				if( walkSpeed.value == "swim" )		walkSpeed.change( "normal" );
				removeSwimEffect();
			}// if:  just stepped OUT of water
		},// terrainChange()
		enable:function(){
			walk_obj.wallValues = wallTerrain;
		},
		disable:function(){
			// treat water tiles as walls  (include water tiles in the list of walls to collide with)
			walk_obj.wallValues = wallTerrain.concat( waterTerrain );
		}
	}// swim_obj
	
	
	var old_waterFeet_settings = null;		// water-effect settings that were in effect before the player entered the water
	function showSplash(){
		var newDepth = nextDepth(OVERLAY);
		var newName = "splash_"+newDepth;
		var newSplash = OVERLAY.createEmptyMovieClip( newName, newDepth );
		newSplash._x = _x;
		newSplash._y = _y;
		loadImage( "swf\\splash.swf", newSplash );
	}// showSplash()
	
	
	
	function addSwimEffect(){
		var deepWater_settings = {
			waterDepth: swim_waterDepth,
			hasRipples: true,
			hasFoam: true,
			sink: true
		}
		
		if(waterFeet){
			old_waterFeet_settings = {
				waterDepth: waterFeet.waterDepth,
				hasRipples: waterFeet.hasRipples,
				hasFoam: waterFeet.hasFoam,
				sink: waterFeet.sink,
				_y: image._y
			};
			applySettings();
		}// if: waterFeet already exists
		else
		{// if: waterFeet does NOT currently exist
			loadImage( "swf\\waterFeet.swf", _this, waterFeet_name, waterFeet_depth )
			.waitForLoad( applySettings );
		}// if: waterFeet does NOT currently exist
		
		
		function applySettings( newClip ){
			var waterFeet  =  _this.waterFeet  =  newClip || waterFeet;
			for(var nam in deepWater_settings){
				waterFeet[nam] = deepWater_settings[nam];
			}// for:  each setting
		}// applySettings()
	}// addSwimEffect()
	
	
	
	function removeSwimEffect(){
		//if( !waterFeet )		return;		// if:  waterFeet does not exist,  then do nothing
		
		if( old_waterFeet_settings )
		{// if:  there was a water effect before the player entered the water
			waterFeet.waterDepth = old_waterFeet_settings.waterDepth;
			waterFeet.hasRipples = old_waterFeet_settings.hasRipples;
			waterFeet.hasFoam = old_waterFeet_settings.hasFoam;
			waterFeet.sink = old_waterFeet_settings.sink;
			//image._y = old_waterFeet_settings._y;
			old_waterFeet_settings = null;
			delete _this.old_waterFeet_settings;
		}// if:  there was a water effect before the player entered the water
		else
		{// if:  there was NO pre-existing water-effect before the player entered the water
			callUnload( waterFeet );
			waterFeet.removeMovieClip();
			delete _this.waterFeet;
		}// if:  there was NO pre-existing water-effect before the player entered the water
	}// removeSwimEffect()
	
	
	function isWaterTerrain( checkTerrain ){
		var output = false;
		for(var t=0; t<waterTerrain.length; t++){
			if(waterTerrain[t] === checkTerrain){
				output = true;
				break;
			}// if:  checkTerrain is one of the valid options, then pass
		}// for:  each waterTerrain
		return output;
	}// isWaterTerrain()
	
	
	react.to("terrainChange").then = swim_obj.terrainChange;
	
	react.to("unload").then = function(){
		// revert wall-collision to normal values
		walk_obj.wallValues = wallTerrain;
	}// onUnload()
	
	return swim_obj;
})// make swim_obj()